using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmUpdateReagentInventory
	/// </summary>
	public class FrmUpdateReagentInventory : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Form Controls
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.GroupBox grpInventory;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.Panel pnlContainer;
		private System.Windows.Forms.Panel pnlTreeView;
		private System.Windows.Forms.Splitter splitter1;
		private System.Windows.Forms.Panel pnlTreeViewHeader;
		private System.Windows.Forms.Panel pnlReagentHeader;
		private System.Windows.Forms.ImageList imageList1;
		private System.Windows.Forms.Panel pnlReagentType;
		private System.Windows.Forms.Panel pnlReagentName;
		private System.Windows.Forms.TextBox txtMinStockLevel;
		private System.Windows.Forms.Label lblMinStockLevel;
		private System.Windows.Forms.TextBox txtReagentType;
		private System.Windows.Forms.Label lblReagentType;
		private System.Windows.Forms.Panel pnlLot;
		private System.Windows.Forms.TextBox txtComments;
		private System.Windows.Forms.Label lblComments;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbReason;
		private System.Windows.Forms.Label lblReason;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updVialsAvailable;
		private System.Windows.Forms.Label lblVialsAvailable;
		private System.Windows.Forms.TextBox txtExpirationDate;
		private System.Windows.Forms.Label lblExpirationDate;
		private System.Windows.Forms.TextBox txtLotNumber;
		private System.Windows.Forms.Label lblLotNumber;
		private System.Windows.Forms.PictureBox picTubes;
		private System.Windows.Forms.DateTimePicker dtpDateTime;
		private System.Windows.Forms.Label lblDateTime;
		private System.Windows.Forms.TextBox txtManufacturer;
		private System.Windows.Forms.Label lblManufacturer;
		private System.Windows.Forms.TextBox txtReagentName;
		private System.Windows.Forms.Label lblReagentName;
		private System.Windows.Forms.Label lblReagentHeader;
		private System.Windows.Forms.PictureBox picFlask;
		private System.Windows.Forms.Label lblInventory;
		private System.Windows.Forms.PictureBox picInventory;
		private System.Windows.Forms.TreeView tvInventory;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnUpdate;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.TextBox txtLotSearch;
		private System.Windows.Forms.Button btnSearch;
		private System.Windows.Forms.Label lblInspection;
		private System.Windows.Forms.RadioButton rdoSatisfactory;
		private System.Windows.Forms.RadioButton rdoUnsatisfactory;
		private System.ComponentModel.IContainer components = null;
		private TreeNode _foundNode;
		private DataRow _drSelectedReagent = null;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.ErrorProvider errorProvider1;

		#endregion

		#region Variables

		private DataTable _dtReagentChangeDetails;
		private DataTable _dtReagentList;
		/// <summary>
		/// Current date value based on the division time zone
		/// </summary>
		private	System.DateTime _currentDate;
		private bool _validVialCount = false;
        private bool _isLoading = false;        //Needed to bypass the lock grab when the controls are being populated. _Changed events!!
		#endregion 

		#region Constructors/Dispose

		/// <summary>
		/// Constructor
		/// </summary>
		public FrmUpdateReagentInventory()
		{
			this.LockController.LockFunction = Common.LockFunctions.UC020MaintainReagentInventory;

			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();
			_dtReagentList = LoadReagentList();
			PopulateTree();
			LoadReagentChangeDetails();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FrmUpdateReagentInventory));
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.picTubes = new System.Windows.Forms.PictureBox();
			this.grpInventory = new System.Windows.Forms.GroupBox();
			this.pnlContainer = new System.Windows.Forms.Panel();
			this.pnlReagentType = new System.Windows.Forms.Panel();
			this.pnlLot = new System.Windows.Forms.Panel();
			this.rdoUnsatisfactory = new System.Windows.Forms.RadioButton();
			this.rdoSatisfactory = new System.Windows.Forms.RadioButton();
			this.lblInspection = new System.Windows.Forms.Label();
			this.btnUpdate = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.dtpDateTime = new System.Windows.Forms.DateTimePicker();
			this.lblDateTime = new System.Windows.Forms.Label();
			this.txtComments = new System.Windows.Forms.TextBox();
			this.lblComments = new System.Windows.Forms.Label();
			this.cmbReason = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblReason = new System.Windows.Forms.Label();
			this.updVialsAvailable = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.lblVialsAvailable = new System.Windows.Forms.Label();
			this.txtExpirationDate = new System.Windows.Forms.TextBox();
			this.lblExpirationDate = new System.Windows.Forms.Label();
			this.txtLotNumber = new System.Windows.Forms.TextBox();
			this.lblLotNumber = new System.Windows.Forms.Label();
			this.pnlReagentName = new System.Windows.Forms.Panel();
			this.txtManufacturer = new System.Windows.Forms.TextBox();
			this.lblManufacturer = new System.Windows.Forms.Label();
			this.txtReagentName = new System.Windows.Forms.TextBox();
			this.lblReagentName = new System.Windows.Forms.Label();
			this.txtMinStockLevel = new System.Windows.Forms.TextBox();
			this.lblMinStockLevel = new System.Windows.Forms.Label();
			this.txtReagentType = new System.Windows.Forms.TextBox();
			this.lblReagentType = new System.Windows.Forms.Label();
			this.pnlReagentHeader = new System.Windows.Forms.Panel();
			this.lblReagentHeader = new System.Windows.Forms.Label();
			this.picFlask = new System.Windows.Forms.PictureBox();
			this.splitter1 = new System.Windows.Forms.Splitter();
			this.pnlTreeView = new System.Windows.Forms.Panel();
			this.btnSearch = new System.Windows.Forms.Button();
			this.txtLotSearch = new System.Windows.Forms.TextBox();
			this.label1 = new System.Windows.Forms.Label();
			this.tvInventory = new System.Windows.Forms.TreeView();
			this.imageList1 = new System.Windows.Forms.ImageList(this.components);
			this.pnlTreeViewHeader = new System.Windows.Forms.Panel();
			this.lblInventory = new System.Windows.Forms.Label();
			this.picInventory = new System.Windows.Forms.PictureBox();
			this.btnCancel = new System.Windows.Forms.Button();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.errorProvider1 = new System.Windows.Forms.ErrorProvider();
			this.grpImage.SuspendLayout();
			this.grpInventory.SuspendLayout();
			this.pnlContainer.SuspendLayout();
			this.pnlReagentType.SuspendLayout();
			this.pnlLot.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.updVialsAvailable)).BeginInit();
			this.pnlReagentName.SuspendLayout();
			this.pnlReagentHeader.SuspendLayout();
			this.pnlTreeView.SuspendLayout();
			this.pnlTreeViewHeader.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(624, 30);
			this.vbecsLogo1.TabIndex = 2;
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 477);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 4;
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.picTubes);
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 420);
			this.grpImage.TabIndex = 3;
			this.grpImage.TabStop = false;
			// 
			// picTubes
			// 
			this.picTubes.Image = ((System.Drawing.Image)(resources.GetObject("picTubes.Image")));
			this.picTubes.Location = new System.Drawing.Point(4, 16);
			this.picTubes.Name = "picTubes";
			this.picTubes.Size = new System.Drawing.Size(45, 44);
			this.picTubes.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picTubes.TabIndex = 0;
			this.picTubes.TabStop = false;
			// 
			// grpInventory
			// 
			this.grpInventory.AccessibleDescription = "Update Reagent Inventory";
			this.grpInventory.AccessibleName = "Update Reagent Inventory";
			this.grpInventory.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpInventory.Controls.Add(this.pnlContainer);
			this.grpInventory.Location = new System.Drawing.Point(60, 32);
			this.grpInventory.Name = "grpInventory";
			this.grpInventory.Size = new System.Drawing.Size(560, 420);
			this.grpInventory.TabIndex = 0;
			this.grpInventory.TabStop = false;
			// 
			// pnlContainer
			// 
			this.pnlContainer.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlContainer.Controls.Add(this.pnlReagentType);
			this.pnlContainer.Controls.Add(this.splitter1);
			this.pnlContainer.Controls.Add(this.pnlTreeView);
			this.pnlContainer.Location = new System.Drawing.Point(8, 12);
			this.pnlContainer.Name = "pnlContainer";
			this.pnlContainer.Size = new System.Drawing.Size(544, 400);
			this.pnlContainer.TabIndex = 0;
			// 
			// pnlReagentType
			// 
			this.pnlReagentType.Controls.Add(this.pnlReagentName);
			this.pnlReagentType.Controls.Add(this.txtMinStockLevel);
			this.pnlReagentType.Controls.Add(this.lblMinStockLevel);
			this.pnlReagentType.Controls.Add(this.txtReagentType);
			this.pnlReagentType.Controls.Add(this.lblReagentType);
			this.pnlReagentType.Controls.Add(this.pnlReagentHeader);
			this.pnlReagentType.Controls.Add(this.pnlLot);
			this.pnlReagentType.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlReagentType.Location = new System.Drawing.Point(175, 0);
			this.pnlReagentType.Name = "pnlReagentType";
			this.pnlReagentType.Size = new System.Drawing.Size(369, 400);
			this.pnlReagentType.TabIndex = 2;
			// 
			// pnlLot
			// 
			this.pnlLot.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlLot.Controls.Add(this.rdoUnsatisfactory);
			this.pnlLot.Controls.Add(this.rdoSatisfactory);
			this.pnlLot.Controls.Add(this.lblInspection);
			this.pnlLot.Controls.Add(this.btnUpdate);
			this.pnlLot.Controls.Add(this.dtpDateTime);
			this.pnlLot.Controls.Add(this.lblDateTime);
			this.pnlLot.Controls.Add(this.txtComments);
			this.pnlLot.Controls.Add(this.lblComments);
			this.pnlLot.Controls.Add(this.cmbReason);
			this.pnlLot.Controls.Add(this.lblReason);
			this.pnlLot.Controls.Add(this.updVialsAvailable);
			this.pnlLot.Controls.Add(this.lblVialsAvailable);
			this.pnlLot.Controls.Add(this.txtExpirationDate);
			this.pnlLot.Controls.Add(this.lblExpirationDate);
			this.pnlLot.Controls.Add(this.txtLotNumber);
			this.pnlLot.Controls.Add(this.lblLotNumber);
			this.pnlLot.Location = new System.Drawing.Point(0, 128);
			this.pnlLot.Name = "pnlLot";
			this.pnlLot.Size = new System.Drawing.Size(368, 272);
			this.pnlLot.TabIndex = 6;
			// 
			// rdoUnsatisfactory
			// 
			this.rdoUnsatisfactory.AccessibleDescription = "Inspection Unsatisfactory";
			this.rdoUnsatisfactory.AccessibleName = "Inspection Unsatisfactory";
			this.rdoUnsatisfactory.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.rdoUnsatisfactory.ImageAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.rdoUnsatisfactory.Location = new System.Drawing.Point(256, 48);
			this.rdoUnsatisfactory.Name = "rdoUnsatisfactory";
			this.rdoUnsatisfactory.TabIndex = 9;
			this.rdoUnsatisfactory.Text = "&Unsatisfactory";
			this.rdoUnsatisfactory.Click += new System.EventHandler(this.rdoUnsatisfactory_Click);
			// 
			// rdoSatisfactory
			// 
			this.rdoSatisfactory.AccessibleDescription = "Inspection Satisfactory";
			this.rdoSatisfactory.AccessibleName = "Inspection Satisfactory";
			this.rdoSatisfactory.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.rdoSatisfactory.Location = new System.Drawing.Point(152, 48);
			this.rdoSatisfactory.Name = "rdoSatisfactory";
			this.rdoSatisfactory.Size = new System.Drawing.Size(88, 24);
			this.rdoSatisfactory.TabIndex = 8;
			this.rdoSatisfactory.TabStop = true;
			this.rdoSatisfactory.Text = "&Satisfactory";
			this.rdoSatisfactory.Click += new System.EventHandler(this.rdoSatisfactory_Click);
			// 
			// lblInspection
			// 
			this.lblInspection.Location = new System.Drawing.Point(8, 52);
			this.lblInspection.Name = "lblInspection";
			this.lblInspection.Size = new System.Drawing.Size(140, 20);
			this.lblInspection.TabIndex = 4;
			this.lblInspection.Text = "Inspection";
			this.lblInspection.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnUpdate
			// 
			this.btnUpdate.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnUpdate.EnabledButton = false;
			this.btnUpdate.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnUpdate.Image = ((System.Drawing.Image)(resources.GetObject("btnUpdate.Image")));
			this.btnUpdate.Location = new System.Drawing.Point(292, 248);
			this.btnUpdate.Name = "btnUpdate";
			this.btnUpdate.Size = new System.Drawing.Size(75, 23);
			this.btnUpdate.TabIndex = 15;
			this.btnUpdate.Click += new System.EventHandler(this.btnUpdate_Click);
			// 
			// dtpDateTime
			// 
			this.dtpDateTime.AccessibleDescription = "Date Time Changed";
			this.dtpDateTime.AccessibleName = "Date Time Changed";
			this.dtpDateTime.CustomFormat = "";
			this.dtpDateTime.Enabled = false;
			this.dtpDateTime.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpDateTime.Location = new System.Drawing.Point(152, 100);
			this.dtpDateTime.Name = "dtpDateTime";
			this.dtpDateTime.Size = new System.Drawing.Size(164, 20);
			this.dtpDateTime.TabIndex = 11;
			this.dtpDateTime.Leave += new System.EventHandler(this.dtpDateTime_Leave);
			this.dtpDateTime.ValueChanged += new System.EventHandler(this.SetDirtyFlag);
			// 
			// lblDateTime
			// 
			this.lblDateTime.Location = new System.Drawing.Point(8, 100);
			this.lblDateTime.Name = "lblDateTime";
			this.lblDateTime.Size = new System.Drawing.Size(140, 20);
			this.lblDateTime.TabIndex = 9;
			this.lblDateTime.Text = "Date/Time Changed*";
			this.lblDateTime.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtComments
			// 
			this.txtComments.AccessibleDescription = "Comments";
			this.txtComments.AccessibleName = "Comments";
			this.txtComments.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtComments.Enabled = false;
			this.txtComments.Location = new System.Drawing.Point(152, 148);
			this.txtComments.MaxLength = 255;
			this.txtComments.Multiline = true;
			this.txtComments.Name = "txtComments";
			this.txtComments.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
			this.txtComments.Size = new System.Drawing.Size(200, 92);
			this.txtComments.TabIndex = 13;
			this.txtComments.Text = "";
			this.txtComments.TextChanged += new System.EventHandler(this.txtComments_TextChanged);
			// 
			// lblComments
			// 
			this.lblComments.Location = new System.Drawing.Point(8, 148);
			this.lblComments.Name = "lblComments";
			this.lblComments.Size = new System.Drawing.Size(140, 20);
			this.lblComments.TabIndex = 13;
			this.lblComments.Text = "Comments";
			this.lblComments.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cmbReason
			// 
			this.cmbReason.AccessibleDescription = "Reason for Change";
			this.cmbReason.AccessibleName = "Reason for Change";
			this.cmbReason.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbReason.Enabled = false;
			this.cmbReason.Interval = 500;
			this.cmbReason.Location = new System.Drawing.Point(152, 124);
			this.cmbReason.Name = "cmbReason";
			this.cmbReason.Size = new System.Drawing.Size(200, 22);
			this.cmbReason.TabIndex = 12;
			this.cmbReason.SelectedIndexChanged += new System.EventHandler(this.cmbReason_SelectedIndexChanged);
			// 
			// lblReason
			// 
			this.lblReason.Location = new System.Drawing.Point(8, 124);
			this.lblReason.Name = "lblReason";
			this.lblReason.Size = new System.Drawing.Size(140, 20);
			this.lblReason.TabIndex = 11;
			this.lblReason.Text = "Reason for Change*";
			this.lblReason.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// updVialsAvailable
			// 
			this.updVialsAvailable.AccessibleDescription = "Number of Vials Available";
			this.updVialsAvailable.AccessibleName = "Number of Vials Available";
			this.updVialsAvailable.Location = new System.Drawing.Point(152, 76);
			this.updVialsAvailable.Maximum = new System.Decimal(new int[] {
																			  999,
																			  0,
																			  0,
																			  0});
			this.updVialsAvailable.Name = "updVialsAvailable";
			this.updVialsAvailable.Size = new System.Drawing.Size(60, 20);
			this.updVialsAvailable.TabIndex = 10;
			this.updVialsAvailable.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updVialsAvailable.Value = new System.Decimal(new int[] {
																			0,
																			0,
																			0,
																			0});
            //this.updVialsAvailable.TextChanged += new System.EventHandler(this.updVialsAvailable_ValueChanged);
            //this.updVialsAvailable.Leave += new System.EventHandler(this.updVialsAvailable_Leave);
            this.updVialsAvailable.ValueChanged += new System.EventHandler(this.updVialsAvailable_ValueChanged);
			// 
			// lblVialsAvailable
			// 
			this.lblVialsAvailable.Location = new System.Drawing.Point(8, 76);
			this.lblVialsAvailable.Name = "lblVialsAvailable";
			this.lblVialsAvailable.Size = new System.Drawing.Size(140, 20);
			this.lblVialsAvailable.TabIndex = 7;
			this.lblVialsAvailable.Text = "Number of Vials Available*";
			this.lblVialsAvailable.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtExpirationDate
			// 
			this.txtExpirationDate.AccessibleDescription = "Expiration Date";
			this.txtExpirationDate.AccessibleName = "Expiration Date";
			this.txtExpirationDate.Location = new System.Drawing.Point(152, 28);
			this.txtExpirationDate.Name = "txtExpirationDate";
			this.txtExpirationDate.ReadOnly = true;
			this.txtExpirationDate.Size = new System.Drawing.Size(160, 20);
			this.txtExpirationDate.TabIndex = 7;
			this.txtExpirationDate.Text = "";
			// 
			// lblExpirationDate
			// 
			this.lblExpirationDate.Location = new System.Drawing.Point(8, 28);
			this.lblExpirationDate.Name = "lblExpirationDate";
			this.lblExpirationDate.Size = new System.Drawing.Size(140, 20);
			this.lblExpirationDate.TabIndex = 2;
			this.lblExpirationDate.Text = "Expiration Date";
			this.lblExpirationDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtLotNumber
			// 
			this.txtLotNumber.AccessibleDescription = "Lot Number";
			this.txtLotNumber.AccessibleName = "Lot Number";
			this.txtLotNumber.Location = new System.Drawing.Point(152, 4);
			this.txtLotNumber.Name = "txtLotNumber";
			this.txtLotNumber.ReadOnly = true;
			this.txtLotNumber.Size = new System.Drawing.Size(160, 20);
			this.txtLotNumber.TabIndex = 6;
			this.txtLotNumber.Text = "";
			// 
			// lblLotNumber
			// 
			this.lblLotNumber.Location = new System.Drawing.Point(8, 4);
			this.lblLotNumber.Name = "lblLotNumber";
			this.lblLotNumber.Size = new System.Drawing.Size(140, 20);
			this.lblLotNumber.TabIndex = 0;
			this.lblLotNumber.Text = "Lot Number";
			this.lblLotNumber.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// pnlReagentName
			// 
			this.pnlReagentName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlReagentName.Controls.Add(this.txtManufacturer);
			this.pnlReagentName.Controls.Add(this.lblManufacturer);
			this.pnlReagentName.Controls.Add(this.txtReagentName);
			this.pnlReagentName.Controls.Add(this.lblReagentName);
			this.pnlReagentName.Location = new System.Drawing.Point(0, 80);
			this.pnlReagentName.Name = "pnlReagentName";
			this.pnlReagentName.Size = new System.Drawing.Size(368, 48);
			this.pnlReagentName.TabIndex = 5;
			this.pnlReagentName.Visible = false;
			// 
			// txtManufacturer
			// 
			this.txtManufacturer.AccessibleDescription = "Manufacturer";
			this.txtManufacturer.AccessibleName = "Manufacturer";
			this.txtManufacturer.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtManufacturer.Location = new System.Drawing.Point(152, 28);
			this.txtManufacturer.Name = "txtManufacturer";
			this.txtManufacturer.ReadOnly = true;
			this.txtManufacturer.Size = new System.Drawing.Size(200, 20);
			this.txtManufacturer.TabIndex = 5;
			this.txtManufacturer.Text = "";
			// 
			// lblManufacturer
			// 
			this.lblManufacturer.Location = new System.Drawing.Point(8, 28);
			this.lblManufacturer.Name = "lblManufacturer";
			this.lblManufacturer.Size = new System.Drawing.Size(140, 20);
			this.lblManufacturer.TabIndex = 2;
			this.lblManufacturer.Text = "Manufacturer";
			this.lblManufacturer.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtReagentName
			// 
			this.txtReagentName.AccessibleDescription = "Manufacturer Reagent Name";
			this.txtReagentName.AccessibleName = "Manufacturer Reagent Name";
			this.txtReagentName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtReagentName.Location = new System.Drawing.Point(152, 4);
			this.txtReagentName.Name = "txtReagentName";
			this.txtReagentName.ReadOnly = true;
			this.txtReagentName.Size = new System.Drawing.Size(200, 20);
			this.txtReagentName.TabIndex = 4;
			this.txtReagentName.Text = "";
			// 
			// lblReagentName
			// 
			this.lblReagentName.Location = new System.Drawing.Point(8, 4);
			this.lblReagentName.Name = "lblReagentName";
			this.lblReagentName.Size = new System.Drawing.Size(152, 20);
			this.lblReagentName.TabIndex = 0;
			this.lblReagentName.Text = "Manufacturer Reagent Name";
			this.lblReagentName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtMinStockLevel
			// 
			this.txtMinStockLevel.AccessibleDescription = "Minimum Vial Stock Level";
			this.txtMinStockLevel.AccessibleName = "Minimum Vial Stock Level";
			this.txtMinStockLevel.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtMinStockLevel.Location = new System.Drawing.Point(152, 60);
			this.txtMinStockLevel.Name = "txtMinStockLevel";
			this.txtMinStockLevel.ReadOnly = true;
			this.txtMinStockLevel.Size = new System.Drawing.Size(60, 20);
			this.txtMinStockLevel.TabIndex = 3;
			this.txtMinStockLevel.Text = "";
			// 
			// lblMinStockLevel
			// 
			this.lblMinStockLevel.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblMinStockLevel.Location = new System.Drawing.Point(8, 60);
			this.lblMinStockLevel.Name = "lblMinStockLevel";
			this.lblMinStockLevel.Size = new System.Drawing.Size(140, 20);
			this.lblMinStockLevel.TabIndex = 3;
			this.lblMinStockLevel.Text = "Minimum Vial Stock Level";
			this.lblMinStockLevel.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtReagentType
			// 
			this.txtReagentType.AccessibleDescription = "Reagent Type";
			this.txtReagentType.AccessibleName = "Reagent Type";
			this.txtReagentType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtReagentType.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtReagentType.Location = new System.Drawing.Point(152, 36);
			this.txtReagentType.Name = "txtReagentType";
			this.txtReagentType.ReadOnly = true;
			this.txtReagentType.Size = new System.Drawing.Size(200, 20);
			this.txtReagentType.TabIndex = 2;
			this.txtReagentType.Text = "";
			// 
			// lblReagentType
			// 
			this.lblReagentType.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblReagentType.Location = new System.Drawing.Point(8, 36);
			this.lblReagentType.Name = "lblReagentType";
			this.lblReagentType.Size = new System.Drawing.Size(140, 20);
			this.lblReagentType.TabIndex = 1;
			this.lblReagentType.Text = "Reagent Type";
			this.lblReagentType.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// pnlReagentHeader
			// 
			this.pnlReagentHeader.BackColor = System.Drawing.SystemColors.ActiveCaption;
			this.pnlReagentHeader.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.pnlReagentHeader.Controls.Add(this.lblReagentHeader);
			this.pnlReagentHeader.Controls.Add(this.picFlask);
			this.pnlReagentHeader.Dock = System.Windows.Forms.DockStyle.Top;
			this.pnlReagentHeader.Location = new System.Drawing.Point(0, 0);
			this.pnlReagentHeader.Name = "pnlReagentHeader";
			this.pnlReagentHeader.Size = new System.Drawing.Size(369, 24);
			this.pnlReagentHeader.TabIndex = 0;
			// 
			// lblReagentHeader
			// 
			this.lblReagentHeader.ForeColor = System.Drawing.SystemColors.ActiveCaptionText;
			this.lblReagentHeader.Location = new System.Drawing.Point(24, 2);
			this.lblReagentHeader.Name = "lblReagentHeader";
			this.lblReagentHeader.Size = new System.Drawing.Size(124, 18);
			this.lblReagentHeader.TabIndex = 0;
			this.lblReagentHeader.Text = "Selected Reagent";
			this.lblReagentHeader.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// picFlask
			// 
			this.picFlask.Image = ((System.Drawing.Image)(resources.GetObject("picFlask.Image")));
			this.picFlask.Location = new System.Drawing.Point(4, 4);
			this.picFlask.Name = "picFlask";
			this.picFlask.Size = new System.Drawing.Size(16, 16);
			this.picFlask.TabIndex = 0;
			this.picFlask.TabStop = false;
			// 
			// splitter1
			// 
			this.splitter1.Location = new System.Drawing.Point(172, 0);
			this.splitter1.Name = "splitter1";
			this.splitter1.Size = new System.Drawing.Size(3, 400);
			this.splitter1.TabIndex = 1;
			this.splitter1.TabStop = false;
			// 
			// pnlTreeView
			// 
			this.pnlTreeView.Controls.Add(this.btnSearch);
			this.pnlTreeView.Controls.Add(this.txtLotSearch);
			this.pnlTreeView.Controls.Add(this.label1);
			this.pnlTreeView.Controls.Add(this.tvInventory);
			this.pnlTreeView.Controls.Add(this.pnlTreeViewHeader);
			this.pnlTreeView.Dock = System.Windows.Forms.DockStyle.Left;
			this.pnlTreeView.Location = new System.Drawing.Point(0, 0);
			this.pnlTreeView.Name = "pnlTreeView";
			this.pnlTreeView.Size = new System.Drawing.Size(172, 400);
			this.pnlTreeView.TabIndex = 0;
			// 
			// btnSearch
			// 
			this.btnSearch.AccessibleDescription = "Search";
			this.btnSearch.AccessibleName = "Search";
			this.btnSearch.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSearch.Enabled = false;
			this.btnSearch.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnSearch.Image = ((System.Drawing.Image)(resources.GetObject("btnSearch.Image")));
			this.btnSearch.Location = new System.Drawing.Point(152, 24);
			this.btnSearch.Name = "btnSearch";
			this.btnSearch.Size = new System.Drawing.Size(20, 20);
			this.btnSearch.TabIndex = 4;
			this.btnSearch.Click += new System.EventHandler(this.btnSearch_Click);
			// 
			// txtLotSearch
			// 
			this.txtLotSearch.AccessibleDescription = "Lot Number Search";
			this.txtLotSearch.AccessibleName = "Lot Number Search";
			this.txtLotSearch.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtLotSearch.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.txtLotSearch.Location = new System.Drawing.Point(32, 24);
			this.txtLotSearch.Name = "txtLotSearch";
			this.txtLotSearch.Size = new System.Drawing.Size(120, 20);
			this.txtLotSearch.TabIndex = 0;
			this.txtLotSearch.Text = "";
			this.txtLotSearch.TextChanged += new System.EventHandler(this.txtLotSearch_TextChanged);
			// 
			// label1
			// 
			this.label1.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.label1.Location = new System.Drawing.Point(0, 24);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(32, 20);
			this.label1.TabIndex = 2;
			this.label1.Text = "Lot #";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// tvInventory
			// 
			this.tvInventory.AccessibleDescription = "Inventory ";
			this.tvInventory.AccessibleName = "Inventory ";
			this.tvInventory.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.tvInventory.ImageList = this.imageList1;
			this.tvInventory.Location = new System.Drawing.Point(0, 44);
			this.tvInventory.Name = "tvInventory";
			this.tvInventory.Size = new System.Drawing.Size(172, 356);
			this.tvInventory.TabIndex = 1;
			this.tvInventory.AfterSelect += new System.Windows.Forms.TreeViewEventHandler(this.tvInventory_AfterSelect);
			// 
			// imageList1
			// 
			this.imageList1.ImageSize = new System.Drawing.Size(16, 16);
			this.imageList1.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList1.ImageStream")));
			this.imageList1.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// pnlTreeViewHeader
			// 
			this.pnlTreeViewHeader.BackColor = System.Drawing.SystemColors.ActiveCaption;
			this.pnlTreeViewHeader.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.pnlTreeViewHeader.Controls.Add(this.lblInventory);
			this.pnlTreeViewHeader.Controls.Add(this.picInventory);
			this.pnlTreeViewHeader.Dock = System.Windows.Forms.DockStyle.Top;
			this.pnlTreeViewHeader.Location = new System.Drawing.Point(0, 0);
			this.pnlTreeViewHeader.Name = "pnlTreeViewHeader";
			this.pnlTreeViewHeader.Size = new System.Drawing.Size(172, 24);
			this.pnlTreeViewHeader.TabIndex = 1;
			// 
			// lblInventory
			// 
			this.lblInventory.ForeColor = System.Drawing.SystemColors.ActiveCaptionText;
			this.lblInventory.Location = new System.Drawing.Point(24, 2);
			this.lblInventory.Name = "lblInventory";
			this.lblInventory.Size = new System.Drawing.Size(124, 18);
			this.lblInventory.TabIndex = 0;
			this.lblInventory.Text = "Inventory";
			this.lblInventory.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// picInventory
			// 
			this.picInventory.Image = ((System.Drawing.Image)(resources.GetObject("picInventory.Image")));
			this.picInventory.Location = new System.Drawing.Point(4, 4);
			this.picInventory.Name = "picInventory";
			this.picInventory.Size = new System.Drawing.Size(16, 16);
			this.picInventory.TabIndex = 0;
			this.picInventory.TabStop = false;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(536, 464);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 14;
			this.btnCancel.Text = "&Close";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// errorProvider1
			// 
			this.errorProvider1.ContainerControl = this;
			this.errorProvider1.DataMember = "";
			this.errorProvider1.Icon = ((System.Drawing.Icon)(resources.GetObject("errorProvider1.Icon")));
			// 
			// FrmUpdateReagentInventory
			// 
			this.AcceptButton = this.btnUpdate;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(624, 493);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.grpInventory);
			this.Controls.Add(this.grpImage);
			this.hlphelpChm.SetHelpKeyword(this, "Update_Reagent_Inventory.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(632, 520);
			this.Name = "FrmUpdateReagentInventory";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Update Reagent Inventory";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmUpdateReagentInventory_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.grpInventory, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.grpImage.ResumeLayout(false);
			this.grpInventory.ResumeLayout(false);
			this.pnlContainer.ResumeLayout(false);
			this.pnlReagentType.ResumeLayout(false);
			this.pnlLot.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.updVialsAvailable)).EndInit();
			this.pnlReagentName.ResumeLayout(false);
			this.pnlReagentHeader.ResumeLayout(false);
			this.pnlTreeView.ResumeLayout(false);
			this.pnlTreeViewHeader.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Methods
		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = "Update Reagent Inventory";
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC020.FrmUpdateReagentInventory());
			//
			this.tvInventory.PathSeparator = "\t";
			//
			this.btnUpdate.Text = "&Update";
			this.btnUpdate.EnabledButton = this.CheckIfEnabled();
			this.pnlReagentType.Visible = false;
			//
			//set custom date and time format
			this.dtpDateTime.CustomFormat = Common.VBECSDateTime.DateTimeFormat;

			//set current date value based on the division time zone
			_currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.dtpDateTime.Value = _currentDate;
			this.dtpDateTime.MaxDate = _currentDate;
		}

		/// <summary>
		/// Get the level of the selected item from the tree
		/// </summary>
		/// <param name="e"></param>
		/// <returns></returns>
		private int getSelectedLevel(TreeNode e)
		{
			string str = e.FullPath;
			string strcmp = this.tvInventory.PathSeparator;
			int pos = 0;
			int level = 0;
			while (str.IndexOf(strcmp,pos) > -1)
			{
				pos = str.IndexOf(strcmp,pos)+1;
				level = level +1;
			}
			return level;
		}

		/// <summary>
		/// Load the reagent list from the database
		/// </summary>
		/// <returns></returns>
		private DataTable LoadReagentList()
		{
			try
			{
				return BOL.Reagent.GetReagents(LogonUser.LogonUserDivisionCode, DateTime.MaxValue, DateTime.MinValue, DateTime.MaxValue, DateTime.MinValue);
			}
			catch (Exception err)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(err.Message));
				return null;
			}		
		}

		/// <summary>
		/// Load the list of reagent change details
		/// </summary>
		private void LoadReagentChangeDetails()
		{
			try
			{
				_dtReagentChangeDetails = BOL.ReagentChange.GetReagentChangeDetails();
				foreach(DataRow _drReagentChangeDetail in _dtReagentChangeDetails.Rows)
				{
					this.cmbReason.Items.Add(_drReagentChangeDetail[Common.VbecsTables.ReagentChangeDetail.ReagentChangeDetailText]);
				}
			}
			catch (Exception err)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(err.Message));
			}
		}

		/// <summary>
		/// Populate the tree with reagent data
		/// </summary>
		private void PopulateTree()
		{
			int nLevelOneIndex, nLevelTwoIndex;
			string ReagentTypeName;

			foreach(DataRow drReagent in _dtReagentList.Rows)
			{
				ReagentTypeName = drReagent[Common.VbecsTables.ReagentType.ReagentTypeName].ToString();

				//Check if reagent type is already a member of a tree
				if ((nLevelOneIndex = IsMemberOfTree(ReagentTypeName, this.tvInventory.Nodes)) != -1)
				{
					//Check if reagent name is already a memeber of a tree
					if ((nLevelTwoIndex = IsMemberOfTree(drReagent[Common.VbecsTables.Reagent.ReagentName].ToString(), 
						this.tvInventory.Nodes[nLevelOneIndex].Nodes)) != -1)
					{
						if (IsMemberOfTree(drReagent[Common.VbecsTables.Reagent.LotNumber].ToString(), 
							this.tvInventory.Nodes[nLevelOneIndex].Nodes[nLevelTwoIndex].Nodes) == -1)
						{
							TreeNode newLevelThreeNode = new TreeNode();
							newLevelThreeNode.ImageIndex = 1;
							newLevelThreeNode.SelectedImageIndex = 1;
							newLevelThreeNode.Text = drReagent[Common.VbecsTables.Reagent.LotNumber].ToString();
							newLevelThreeNode.Tag = drReagent;
							this.tvInventory.Nodes[nLevelOneIndex].Nodes[nLevelTwoIndex].Nodes.Add(newLevelThreeNode);
						}
					}
					else
					{
						TreeNode newLevelTwoNode = new TreeNode();
						newLevelTwoNode.ImageIndex = 5;
						newLevelTwoNode.SelectedImageIndex = 5;
						newLevelTwoNode.Text = drReagent[Common.VbecsTables.Reagent.ReagentName].ToString();
						nLevelTwoIndex = this.tvInventory.Nodes[nLevelOneIndex].Nodes.Add(newLevelTwoNode);
						if (IsMemberOfTree(drReagent[Common.VbecsTables.Reagent.LotNumber].ToString(), this.tvInventory.Nodes[nLevelOneIndex].Nodes[nLevelTwoIndex].Nodes) == -1)
						{
							TreeNode newLevelThreeNode = new TreeNode();
							newLevelThreeNode.ImageIndex = 1;
							newLevelThreeNode.SelectedImageIndex = 1;
							newLevelThreeNode.Text = drReagent[Common.VbecsTables.Reagent.LotNumber].ToString();
							newLevelThreeNode.Tag = drReagent;
							this.tvInventory.Nodes[nLevelOneIndex].Nodes[nLevelTwoIndex].Nodes.Add(newLevelThreeNode);
						}
					}
				}
				else
				{
					TreeNode newLevelOneNode = new TreeNode();
					newLevelOneNode.ImageIndex = 4;
					newLevelOneNode.SelectedImageIndex = 4;
					TreeNode newLevelTwoNode = new TreeNode();
					newLevelTwoNode.ImageIndex = 5;
					newLevelTwoNode.SelectedImageIndex = 5;
					TreeNode newLevelThreeNode = new TreeNode();
					newLevelThreeNode.ImageIndex = 1;
					newLevelThreeNode.SelectedImageIndex = 1;
					newLevelOneNode.Text = ReagentTypeName;
					newLevelTwoNode.Text = drReagent[Common.VbecsTables.Reagent.ReagentName].ToString();

					nLevelOneIndex = this.tvInventory.Nodes.Add(newLevelOneNode);
					nLevelTwoIndex = this.tvInventory.Nodes[nLevelOneIndex].Nodes.Add(newLevelTwoNode);
					newLevelThreeNode.Text = drReagent[Common.VbecsTables.Reagent.LotNumber].ToString();
					newLevelThreeNode.Tag = drReagent;
					this.tvInventory.Nodes[nLevelOneIndex].Nodes[nLevelTwoIndex].Nodes.Add(newLevelThreeNode);
				}
			}
		}

		/// <summary>
		/// Check if the node is already a member of the node collection
		/// </summary>
		/// <param name="sNodeName"></param>
		/// <param name="nodeList"></param>
		/// <returns></returns>
		private int IsMemberOfTree(string sNodeName, TreeNodeCollection nodeList)
		{
			int nIndex = 0;

			foreach(TreeNode node in nodeList)
			{
				if (node.Text == sNodeName)
				{
					return nIndex;
				}
				nIndex++;
			}

			return -1;
		}

		/// <summary>
		/// Display detailed information about the selected node
		/// </summary>
		/// <param name="e"></param>
		private void DisplaySelectedTreeNodeInDetail(TreeNode e)
		{
            this._isLoading = true;     //Setting this because setting updown causes the changed event to fire (when it changes)
                                        //But, if you select vial A with qty3, then select vial B with qty3, it doesn't fire (no change)
                                        //So that makes for inconsistent behavior. 

			int level = getSelectedLevel(e);
			//
			this.Working();
			//
			//We can remove all locks here, because if they're clicking on something, it means that their changes won't persist anyway
			this.UnlockAllRecords();

			switch (level) 
			{
				case 1:
					pnlReagentType.Visible = true;
					pnlReagentName.Visible = true;
					pnlLot.Visible = false;
					_drSelectedReagent = (DataRow)e.FirstNode.Tag;
					if (_drSelectedReagent.IsNull(Common.VbecsTables.ReagentTypeParameter.MinimumStockLevel) == true)
					{
						this.txtMinStockLevel.Text = "0";
					}
					else
					{
						this.txtMinStockLevel.Text = _drSelectedReagent[Common.VbecsTables.ReagentTypeParameter.MinimumStockLevel].ToString();
					}
					this.txtManufacturer.Text = _drSelectedReagent[Common.VbecsTables.Reagent.ReagentManufacturerName].ToString();
					this.txtReagentName.Text = _drSelectedReagent[Common.VbecsTables.Reagent.ReagentName].ToString();
					break;
				case 2:
					pnlReagentType.Visible = true;
					pnlReagentName.Visible = true;
					pnlLot.Visible = true;
					_drSelectedReagent = (DataRow)e.Tag;
					if (_drSelectedReagent.IsNull(Common.VbecsTables.ReagentTypeParameter.MinimumStockLevel) == true)
					{
						this.txtMinStockLevel.Text = "0";
					}
					else
					{
						this.txtMinStockLevel.Text = _drSelectedReagent[Common.VbecsTables.ReagentTypeParameter.MinimumStockLevel].ToString();
					}
					this.txtManufacturer.Text = _drSelectedReagent[Common.VbecsTables.Reagent.ReagentManufacturerName].ToString();
					this.txtReagentName.Text = _drSelectedReagent[Common.VbecsTables.Reagent.ReagentName].ToString();
					this.txtLotNumber.Text = _drSelectedReagent[Common.VbecsTables.Reagent.LotNumber].ToString();
					this.txtExpirationDate.Text = Common.VBECSDateTime.FormatDateTimeString(_drSelectedReagent[Common.VbecsTables.Reagent.LotExpirationDate]);
					if((bool)_drSelectedReagent[Common.VbecsTables.Reagent.InspectionIndicator] == true)
					{
						this.rdoSatisfactory.Checked = true;
						this.rdoUnsatisfactory.Checked = false;
					}
					else
					{
						this.rdoSatisfactory.Checked = false;
						this.rdoUnsatisfactory.Checked = true;
					}
					this.updVialsAvailable.Value = (short)_drSelectedReagent[Common.VbecsTables.Reagent.NumberVialsAvailable];
					this.dtpDateTime.Enabled = false;
					this.cmbReason.Enabled = false;
					this.cmbReason.Text = "";
					this.cmbReason.SelectedIndex = -1;
					this.txtComments.Enabled = false;
					this.txtComments.Text = "";
					this.btnUpdate.EnabledButton = false;
					break;
				default:
					pnlReagentType.Visible = true;
					pnlReagentName.Visible = false;
					pnlLot.Visible = false;
					_drSelectedReagent = (DataRow)e.FirstNode.FirstNode.Tag;
					if (_drSelectedReagent.IsNull(Common.VbecsTables.ReagentTypeParameter.MinimumStockLevel) == true)
					{
						this.txtMinStockLevel.Text = "0";
					}
					else
					{
						this.txtMinStockLevel.Text = _drSelectedReagent[Common.VbecsTables.ReagentTypeParameter.MinimumStockLevel].ToString();
					}
					break;
			}
			this.btnUpdate.EnabledButton = this.CheckIfEnabled();
			//
			string ReagentTypeName = _drSelectedReagent[Common.VbecsTables.ReagentType.ReagentTypeName].ToString();
			this.txtReagentType.Text = ReagentTypeName;
			this.Ready();
			//The BOL variables have been populated with data but they have not been
			//updated or altered. Thus, the form should not be dirty.
			this.IsDirty=false;
            this._isLoading = false;
		}

		#endregion

		#region Event / Event Handlers
		private void tvInventory_AfterSelect(object sender, System.Windows.Forms.TreeViewEventArgs e)
		{
			DisplaySelectedTreeNodeInDetail(e.Node);
			if (_foundNode != null)
			{
				UnSelectFoundNode();
			}
		}

		/// <summary>
		/// Find and select the node
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnSearch_Click(object sender, System.EventArgs e)
		{
			string sLotSearch;

			if (this.txtLotSearch.Text.Trim().Length > 0)
			{
				sLotSearch = this.txtLotSearch.Text.Trim();
				SearchAndOpenNode(sLotSearch);
			}
		}

		/// <summary>
		/// Finds and opens the node with reagent having a certain lot number
		/// </summary>
		/// <param name="lotNumber"></param>
		public void SearchAndOpenNode(string lotNumber)
		{
			int nIndx;

			foreach(TreeNode nodeLevelOne in this.tvInventory.Nodes)
			{
				foreach(TreeNode nodeLevelTwo in nodeLevelOne.Nodes)
				{
					nIndx = 0;
					foreach(TreeNode node in nodeLevelTwo.Nodes)
					{
						if (node.Text.ToLower().IndexOf(lotNumber.ToLower()) == 0)
						{
							nodeLevelOne.Expand();
							nodeLevelTwo.Expand();
							UnSelectFoundNode();
							SelectFoundNode(nodeLevelTwo.Nodes[nIndx]);
							DisplaySelectedTreeNodeInDetail(nodeLevelTwo.Nodes[nIndx]);
							return;
						}
						nIndx++;
					}
				}
			}

			GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC020.NoMatchingEntries());
		}

		/// <summary>
		/// Select the node that has been found by using the search button
		/// </summary>
		/// <param name="node"></param>
		private void SelectFoundNode(TreeNode node)
		{
			_foundNode = node;
			_foundNode.BackColor = SystemColors.Highlight;
			_foundNode.ForeColor = SystemColors.HighlightText;
		}

		/// <summary>
		/// Unselect the node that has been found by using the search button
		/// </summary>
		private void UnSelectFoundNode()
		{
			if (_foundNode != null)
			{
				_foundNode.BackColor = this.tvInventory.BackColor;
				_foundNode.ForeColor = this.tvInventory.ForeColor;
				_foundNode = null;
			}
		}

		private void txtLotSearch_TextChanged(object sender, System.EventArgs e)
		{
			if (this.txtLotSearch.Text.Trim().Length > 0)
			{
				this.btnSearch.Enabled = true;
			}
			else
			{
				this.btnSearch.Enabled = false;
			}
		}

		private bool GetReagentLock()
		{
			//Attempt to Lock the Record First
			if (this._drSelectedReagent == null) return(true);
            if (this._isLoading) return (true);

			BOL.Reagent lockReagent = new BOL.Reagent(this._drSelectedReagent);
			
			return(this.SetLocks(lockReagent.ReagentGuid));
		}



		private void btnUpdate_Click(object sender, System.EventArgs e)
		{

			BOL.Reagent ReagentUpdate;
			BOL.ReagentChange ReagentChangeInsert = new BOL.ReagentChange();
			int nReagentStockLevel;
			bool returnValue = false;

			if (this.cmbReason.Text.Trim() == "Other" && this.txtComments.Text.Trim() == string.Empty)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.FreeTextCommentMustBeEntered("a reason for change of 'Other'"));
				return;
			}
			//
			DialogResult saveResult = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("reagent"));
			if (saveResult == DialogResult.Yes)
			{
				ReagentChangeInsert.ReagentChangeGuid = System.Guid.NewGuid();
				ReagentChangeInsert.ReagentGuid = (System.Guid)_drSelectedReagent[Common.VbecsTables.Reagent.ReagentGuid];
			
				foreach(DataRow drReagentChangeDetail in _dtReagentChangeDetails.Rows)
				{
					if (this.cmbReason.Text.Trim() == drReagentChangeDetail[Common.VbecsTables.ReagentChangeDetail.ReagentChangeDetailText].ToString())
					{
						ReagentChangeInsert.ReagentChangeDetailCode = drReagentChangeDetail[Common.VbecsTables.ReagentChangeDetail.ReagentChangeDetailCode].ToString();
						break;
					}
				}

				ReagentChangeInsert.Comments = this.txtComments.Text;
				ReagentChangeInsert.LastUpdateDate = this.dtpDateTime.Value;

				_drSelectedReagent[Common.VbecsTables.Reagent.NumberVialsAvailable] = this.updVialsAvailable.Value;
				if (this.rdoSatisfactory.Checked == true)
				{
					_drSelectedReagent[Common.VbecsTables.Reagent.InspectionIndicator] = true;
				}
				else
				{
					_drSelectedReagent[Common.VbecsTables.Reagent.InspectionIndicator] = false;
				}
				ReagentUpdate = new BOL.Reagent(_drSelectedReagent);
				try
				{
					returnValue = ReagentUpdate.UpdateReagent(ReagentChangeInsert, this._dtReagentList, Common.UpdateFunction.UC020FrmUpdateReagentInventory);
				
					//CR 1441
					System.Data.DataTable dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int) Common.WorkloadProcessID.UpdateReagentInventory);
					if(dt!= null)
					{
						if(dt.Rows.Count == 0)
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
						}
					}
					//since only one reagent is updated at a time... we can use this function
					this.UnlockAllRecords();
				}
				catch (RowVersionException)
				{
					this.btnUpdate.RowVersionException = true;		//CR2077
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
					return;
				}
				

				nReagentStockLevel = ReagentUpdate.GetReagentTypeStockLevel();
				if (nReagentStockLevel >= 0)
				{
					if (_drSelectedReagent.IsNull(Common.VbecsTables.ReagentTypeParameter.MinimumStockLevel) == false)
					{
						if (nReagentStockLevel <= System.Convert.ToInt32(_drSelectedReagent[Common.VbecsTables.ReagentTypeParameter.MinimumStockLevel]))
						{
							string sMessageBoxText = _drSelectedReagent[Common.VbecsTables.ReagentType.ReagentTypeName].ToString();
							sMessageBoxText += " is at or below the minimum stock level"; 
							GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC020.ReagentTypeStockLevelLow(sMessageBoxText));
						}
					}
				}

				if (returnValue == true)
				{
					_dtReagentList = LoadReagentList();
					PopulateTree();
					LoadReagentChangeDetails();
				}

				this.cmbReason.Text = "";
				this.cmbReason.SelectedIndex = -1;
				this.txtComments.Text = "";
				this.cmbReason.Enabled = false;
				this.txtComments.Enabled = false;
				this.dtpDateTime.Enabled = false;
				this.CheckIfEnabled();
				this.IsDirty = false;
			}

			this.SearchAndOpenNode(this.txtLotNumber.Text);
		}

		private void rdoSatisfactory_Click(object sender, System.EventArgs e)
		{
			if(!this.GetReagentLock()) return;
			this.dtpDateTime.Enabled = true;
			this.cmbReason.Enabled = true;
			this.IsDirty=true;
		}

		private void rdoUnsatisfactory_Click(object sender, System.EventArgs e)
		{
			if(!this.GetReagentLock()) return;
			this.dtpDateTime.Enabled = true;
			this.cmbReason.Enabled = true;
			this.IsDirty=true;
		}

		private void updVialsAvailable_ValueChanged(object sender, System.EventArgs e)
		{
			try
			{
				if(!this.GetReagentLock()) return;
				//this.updVialsAvailable.Value = this.updVialsAvailable.Value;
				this.errError.SetVbecsError(updVialsAvailable, string.Empty); // **** 508 Compliance ***
				this._validVialCount = true;
			}
			catch(FormatException)
			{
				this._validVialCount = false;
			}
			this.dtpDateTime.Enabled = true;
			this.cmbReason.Enabled = true;
			this.IsDirty=true;
			this.btnUpdate.EnabledButton = this.CheckIfEnabled();
		}

		private void updVialsAvailable_Leave(object sender, EventArgs e)
		{
			try
			{
				if(!this.GetReagentLock()) return;

				//this.updVialsAvailable.Value = this.updVialsAvailable.Value;
				this.errError.SetVbecsError(updVialsAvailable, string.Empty); // **** 508 Compliance ***
				this._validVialCount = true;
			}
			catch(FormatException err)
			{
				this._validVialCount = false;
				this.errError.SetVbecsError(updVialsAvailable, err.Message); // **** 508 Compliance ***
			}
			this.btnUpdate.EnabledButton = this.CheckIfEnabled();
		}

		private void cmbReason_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(!this.GetReagentLock()) return;

			if (cmbReason.SelectedIndex != -1)
			{
				if (this.cmbReason.Text.Trim() == "Other")
				{
					this.txtComments.Enabled = true;
					this.lblComments.Text = "Comments*";
				}
				else
				{
					this.txtComments.Text = string.Empty;
					this.txtComments.Enabled = false;
					this.lblComments.Text = "Comments";
				}
				this.btnUpdate.EnabledButton = this.CheckIfEnabled();
			}
		}

		private void dtpDateTime_Leave(object sender, System.EventArgs e)
		{
			if(!this.GetReagentLock()) return;

			this.btnUpdate.EnabledButton = this.CheckIfEnabled();
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private bool CheckIfEnabled()
		{
			if (!this._validVialCount)
			{
				this.btnUpdate.SetToolTip("Vial count entered is outside acceptable range ("+this.updVialsAvailable.Minimum.ToString()+"-"+this.updVialsAvailable.Maximum.ToString()+")");
				return false;
			}

			if (this.dtpDateTime.Value > _currentDate)
			{
				this.btnUpdate.SetToolTip(Common.StrRes.Tooltips.UC020.DateTime().ResString);
				return false;
			}

			if (this.cmbReason.SelectedIndex == -1)
			{
				this.btnUpdate.SetToolTip(Common.StrRes.Tooltips.UC020.ReasonForChange().ResString);
				return false;
			}
			else if (this.cmbReason.Text == "Other")
			{
				if (this.txtComments.Text == "")
				{
					this.btnUpdate.SetToolTip(Common.StrRes.Tooltips.UC020.Comment().ResString);
					return false;
				}
				else
				{
					this.btnUpdate.SetToolTip("");
					return true;
				}
			}
			else
			{
				this.btnUpdate.SetToolTip("");
				return true;
			}
		}

		private void txtComments_TextChanged(object sender, System.EventArgs e)
		{
			if(!this.GetReagentLock()) return;
			this.btnUpdate.EnabledButton = this.CheckIfEnabled();
		}
		
		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmUpdateReagentInventory_KeyDownSpeakMessage(object sender, System.EventArgs e)
		{
			string textToSpeak = "";

			if (this.btnUpdate.EnabledButton == false)
			{
				textToSpeak = this.btnUpdate.GetToolTip();
			}

			this.SpeakMessage( textToSpeak );		
		}

		#endregion

	}
}

